/**
 * Created by lei.wang_1 on 2016/9/6.
 */
appModule.directive("noticeTimeLine", ["utils",function (utils) {
    return {
        template: '<div class="timeLine"></div>',
        restrict: 'E',
        replace:true,
        scope: {
            duration:'=' //单位秒
        },
        link: function ($scope, element) {
            function render(timestamp){
                var dtTxt = utils.time2str(timestamp/1000, true);
                element.text(dtTxt);
            }

            var stopWatch = $scope.$watch('duration',function(newV){
                if(newV){
                    render(newV);
                }
            });

            render($scope.duration);

            $scope.$on('$destroy',function(){
                stopWatch();
            });
        }
    };
}]);
